/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jemu.settings.FavoriteSettings;
import jemu.ui.Main;
import jemu.ui.wavtocpc.SyntheticaLicense;

public class Browser
extends JInternalFrame {
    String[] history;
    String[] favorites;
    String[] favoritesUrl;
    private final JFXPanel jfxPanel = new JFXPanel();
    private WebEngine engine;
    private final JPanel panel = new JPanel(new BorderLayout());
    private final JLabel lblStatus = new JLabel();
    private final JButton btnPlus = new JButton("+F");
    private final JButton btnMinus = new JButton("-F");
    private final JButton btnGo = new JButton("Go");
    private final JButton btnHome = new JButton("Home");
    private final JButton btnBack = new JButton("Back");
    private final JPanel control = new JPanel();
    private final JPanel address = new JPanel();
    private final JPanel btnF = new JPanel();
    private final JComboBox favs = new JComboBox();
    private final JTextField txtURL = new JTextField();
    private final JProgressBar progressBar = new JProgressBar();
    private final String home = "http://cpc-live.com/";
    private String lastUrl = "";
    private String checkUrl = "";
    boolean adding = false;
    boolean dontadd = false;
    ComboBoxModel model;
    private String[] downloadExtensions = new String[]{".zip", ".rar", ".7z", ".exe", ".mp4", ".avi", ".mov", ".wmv", ".dsk", ".cdt", ".sna", ".csw", ".wav", ".pdf", ".dll", ".jar", ".cpr", ".mp3"};
    String fileExt;
    boolean isDownloading;
    int historyindex = 1;
    FileDialog downDiag;

    public Browser() {
        this.history = new String[0];
        this.progressBar.setMaximum(100);
        this.initComponents();
    }

    public void remFav() {
        int i;
        if (this.favorites == null || this.favorites.length < 1) {
            return;
        }
        int index = this.favs.getSelectedIndex();
        if (index < 0) {
            return;
        }
        String[] buffer = new String[this.favorites.length - 1];
        String[] bufferu = new String[this.favorites.length - 1];
        for (i = 0; i < index; ++i) {
            buffer[i] = this.favorites[i];
            bufferu[i] = this.favoritesUrl[i];
        }
        for (i = index + 1; i < this.favorites.length; ++i) {
            buffer[i - 1] = this.favorites[i];
            bufferu[i - 1] = this.favoritesUrl[i];
        }
        this.favorites = new String[buffer.length];
        this.favoritesUrl = new String[bufferu.length];
        System.arraycopy(buffer, 0, this.favorites, 0, buffer.length);
        System.arraycopy(bufferu, 0, this.favoritesUrl, 0, bufferu.length);
        this.favs.removeAllItems();
        this.favs.setModel(new DefaultComboBoxModel<String>(this.favorites));
        this.updateSettings();
        if (this.favorites.length < 1) {
            this.btnMinus.setVisible(false);
            this.favs.setVisible(false);
        }
    }

    public void addFav() {
        String url = this.engine.getLocation();
        String title = this.engine.getTitle();
        if (this.favorites != null && this.favorites.length >= 99) {
            return;
        }
        if (this.favorites == null) {
            this.favorites = new String[1];
            this.favoritesUrl = new String[1];
            this.favorites[0] = title;
            this.favoritesUrl[0] = url;
        } else {
            String[] buffer = new String[this.favorites.length];
            String[] bufferu = new String[this.favoritesUrl.length];
            System.arraycopy(this.favorites, 0, buffer, 0, buffer.length);
            System.arraycopy(this.favoritesUrl, 0, bufferu, 0, buffer.length);
            this.favorites = new String[this.favorites.length + 1];
            this.favoritesUrl = new String[this.favoritesUrl.length + 1];
            System.arraycopy(buffer, 0, this.favorites, 0, buffer.length);
            System.arraycopy(bufferu, 0, this.favoritesUrl, 0, bufferu.length);
            this.favorites[this.favorites.length - 1] = title;
            this.favoritesUrl[this.favoritesUrl.length - 1] = url;
        }
        this.favs.removeAllItems();
        this.favs.setModel(new DefaultComboBoxModel<String>(this.favorites));
        this.updateSettings();
        this.btnMinus.setVisible(true);
        this.favs.setVisible(true);
    }

    public void addFav(String url, String title) {
        System.out.println("Fav added:" + title);
        this.btnMinus.setVisible(true);
        this.favs.setVisible(true);
        if (this.favorites != null && this.favorites.length >= 99) {
            return;
        }
        if (this.favorites == null) {
            this.favorites = new String[1];
            this.favoritesUrl = new String[1];
            this.favorites[0] = title;
            this.favoritesUrl[0] = url;
        } else {
            String[] buffer = new String[this.favorites.length];
            String[] bufferu = new String[this.favoritesUrl.length];
            System.arraycopy(this.favorites, 0, buffer, 0, buffer.length);
            System.arraycopy(this.favoritesUrl, 0, bufferu, 0, buffer.length);
            this.favorites = new String[this.favorites.length + 1];
            this.favoritesUrl = new String[this.favoritesUrl.length + 1];
            System.arraycopy(buffer, 0, this.favorites, 0, buffer.length);
            System.arraycopy(bufferu, 0, this.favoritesUrl, 0, bufferu.length);
            this.favorites[this.favorites.length - 1] = title;
            this.favoritesUrl[this.favoritesUrl.length - 1] = url;
        }
        this.favs.removeAllItems();
        this.favs.setModel(new DefaultComboBoxModel<String>(this.favorites));
    }

    private void updateSettings() {
        for (int i = 0; i < 100; ++i) {
            try {
                FavoriteSettings.set(i + "_title", this.favorites[i]);
                FavoriteSettings.set(i + "_url", this.favoritesUrl[i]);
                continue;
            }
            catch (Exception e) {
                FavoriteSettings.set(i + "_title", "*empty*");
                FavoriteSettings.set(i + "_url", "*empty*");
            }
        }
    }

    private void getFavorites() {
        for (int i = 0; i < 100; ++i) {
            String title = FavoriteSettings.get(i + "_title", "*empty*");
            String url = FavoriteSettings.get(i + "_url", "*empty*");
            if (title.contains("*empty*")) continue;
            this.addFav(url, title);
        }
    }

    public void addHistory() {
        if (this.adding) {
            return;
        }
        if (this.dontadd) {
            this.dontadd = false;
            return;
        }
        this.adding = true;
        Thread add = new Thread(){

            @Override
            public void run() {
                int check = -100;
                while (check < 100) {
                    check = Browser.this.progressBar.getValue();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                String url = Browser.this.engine.getLocation();
                String[] buffer = new String[Browser.this.history.length + 1];
                System.arraycopy(Browser.this.history, 0, buffer, 0, Browser.this.history.length);
                buffer[buffer.length - 1] = url;
                Browser.this.history = new String[buffer.length];
                System.arraycopy(buffer, 0, Browser.this.history, 0, Browser.this.history.length);
                System.out.println("History added: " + url);
                Browser.this.adding = false;
            }
        };
        add.start();
    }

    private void initComponents() {
        this.createScene();
        this.btnMinus.setVisible(false);
        this.favs.setVisible(false);
        this.control.setLayout(new BorderLayout());
        this.address.setLayout(new BorderLayout());
        this.btnF.setLayout(new BorderLayout());
        this.btnHome.setFocusable(false);
        this.btnBack.setFocusable(false);
        this.btnGo.setFocusable(false);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == Browser.this.favs) {
                    int i = Browser.this.favs.getSelectedIndex();
                    if (i > -1) {
                        String url = Browser.this.favoritesUrl[i];
                        Browser.this.setURL(url);
                    }
                    return;
                }
                if (e.getSource() == Browser.this.btnPlus) {
                    Browser.this.addFav();
                    return;
                }
                if (e.getSource() == Browser.this.btnMinus) {
                    Browser.this.remFav();
                    return;
                }
                if (e.getSource() == Browser.this.btnHome) {
                    Browser.this.setURL("http://cpc-live.com/");
                    Browser.this.historyindex = 1;
                    return;
                }
                if (e.getSource() == Browser.this.btnBack) {
                    Browser.this.Back();
                    return;
                }
                Browser.this.historyindex = 1;
                String url = Browser.this.txtURL.getText();
                if (!url.startsWith("http")) {
                    url = url.endsWith(".com") || url.endsWith(".de") || url.endsWith(".fr") || url.endsWith(".org") || url.endsWith(".net") || url.endsWith(".eu") || url.endsWith(".at") || url.endsWith(".ch") ? "http://" + url : "https://google.com/search?q=" + url + "&oq=" + url;
                }
                Browser.this.setURL(url);
            }
        };
        ItemListener il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
            }
        };
        MouseListener ml = new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getSource() == Browser.this.txtURL) {
                    Browser.this.txtURL.selectAll();
                }
            }
        };
        this.btnPlus.addActionListener(al);
        this.btnMinus.addActionListener(al);
        this.btnGo.addActionListener(al);
        this.btnBack.addActionListener(al);
        this.btnHome.addActionListener(al);
        this.txtURL.addActionListener(al);
        this.txtURL.addMouseListener(ml);
        this.favs.addItemListener(il);
        this.favs.addActionListener(al);
        this.progressBar.setPreferredSize(new Dimension(150, 18));
        this.progressBar.setStringPainted(true);
        JPanel topBar = new JPanel(new BorderLayout(5, 0));
        topBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        topBar.add((Component)this.txtURL, "Center");
        this.favs.setPreferredSize(new Dimension(150, -1));
        this.btnF.add((Component)this.btnMinus, "West");
        this.btnF.add((Component)this.btnPlus, "East");
        this.address.add((Component)this.btnF, "West");
        this.address.add((Component)this.favs, "Center");
        this.address.add((Component)this.btnGo, "East");
        topBar.add((Component)this.address, "East");
        this.control.add((Component)this.btnHome, "West");
        this.control.add((Component)this.btnBack, "East");
        topBar.add((Component)this.control, "West");
        JPanel statusBar = new JPanel(new BorderLayout(5, 0));
        statusBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        statusBar.add((Component)this.lblStatus, "Center");
        statusBar.add((Component)this.progressBar, "East");
        this.panel.add((Component)topBar, "North");
        this.panel.add((Component)this.jfxPanel, "Center");
        this.panel.add((Component)statusBar, "South");
        this.getContentPane().add(this.panel);
        this.setPreferredSize(new Dimension(1024, 600));
        this.setDefaultCloseOperation(3);
        this.pack();
        this.getFavorites();
    }

    private void checkDownload(String url) {
        String file = url;
        while (file.contains("/")) {
            file = file.substring(1);
        }
        while (file.contains("?")) {
            file = file.substring(0, file.length() - 1);
        }
        for (String downloadExtension : this.downloadExtensions) {
            if (!file.toLowerCase().contains(downloadExtension)) continue;
            try {
                this.fileExt = downloadExtension;
                this.download(url, file);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addHistory();
    }

    private int getFileSize(String ur) {
        int n;
        URL url = new URL(ur);
        URLConnection conn = null;
        try {
            conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).setRequestMethod("HEAD");
            }
            conn.getInputStream();
            n = conn.getContentLength();
        }
        catch (IOException e) {
            try {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (conn instanceof HttpURLConnection) {
                        ((HttpURLConnection)conn).disconnect();
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                return 0;
            }
        }
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
        return n;
    }

    public void download(String urlString, String filename) {
        if (this.downDiag == null) {
            this.downDiag = new FileDialog((Frame)new JFrame(), "Save file...", 1);
        }
        this.downDiag.setFile(filename);
        this.downDiag.setVisible(true);
        String path = this.downDiag.getDirectory();
        String file = this.downDiag.getFile();
        if (path != null && file != null) {
            if (!file.toLowerCase().endsWith(this.fileExt)) {
                file = file + this.fileExt;
            }
            this.download(path, urlString, file);
        } else {
            if (!this.lastUrl.contains(this.checkUrl)) {
                this.setURL(this.lastUrl);
            }
            this.checkUrl = this.lastUrl;
        }
    }

    public void download(String folder, final String urlString, String filename) {
        final String file = folder + filename;
        if (this.isDownloading) {
            if (!this.lastUrl.contains(this.checkUrl)) {
                this.setURL(this.lastUrl);
            }
            this.checkUrl = this.lastUrl;
            return;
        }
        Thread Runner = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Browser.this.isDownloading = true;
                    if (!Browser.this.lastUrl.contains(Browser.this.checkUrl)) {
                        Browser.this.setURL(Browser.this.lastUrl);
                    }
                    Browser.this.checkUrl = Browser.this.lastUrl;
                    BufferedInputStream in = null;
                    FileOutputStream fout = null;
                    try {
                        int count;
                        in = new BufferedInputStream(new URL(urlString).openStream());
                        fout = new FileOutputStream(file);
                        int size = Browser.this.getFileSize(urlString);
                        Browser.this.progressBar.setMaximum(size);
                        byte[] data = new byte[1024];
                        while ((count = in.read(data, 0, 1024)) != -1) {
                            fout.write(data, 0, count);
                            Browser.this.progressBar.setValue(Browser.this.progressBar.getValue() + 1024);
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                        if (fout != null) {
                            fout.close();
                        }
                    }
                    Browser.this.progressBar.setMaximum(100);
                    Browser.this.progressBar.setValue(0);
                    Browser.this.isDownloading = false;
                }
                catch (Exception e) {
                    Browser.this.progressBar.setMaximum(100);
                    Browser.this.progressBar.setValue(0);
                    Browser.this.isDownloading = false;
                }
            }
        };
        Runner.start();
    }

    private void Back() {
        if (this.history == null || this.history.length < 2) {
            return;
        }
        String url = this.history[this.history.length - 2];
        String[] buffer = new String[this.history.length - 1];
        System.arraycopy(this.history, 0, buffer, 0, buffer.length);
        this.history = new String[buffer.length];
        System.arraycopy(buffer, 0, this.history, 0, this.history.length);
        this.dontadd = true;
        this.setURL(url);
    }

    private void createScene() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebView view = new WebView();
                Browser.this.engine = view.getEngine();
                Browser.this.engine.setUserAgent("CPCilla/5.0 - JavaCPC Webbrowser/" + Main.version + Main.subversion);
                Browser.this.engine.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Browser.this.setTitle(newValue);
                            }
                        });
                    }
                });
                Browser.this.engine.setOnStatusChanged(new EventHandler<WebEvent<String>>(){

                    public void handle(final WebEvent<String> event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Browser.this.lblStatus.setText((String)event.getData());
                            }
                        });
                    }
                });
                Browser.this.engine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> ov, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                boolean change = true;
                                for (int i = 0; i < Browser.this.downloadExtensions.length; ++i) {
                                    if (!newValue.toLowerCase().contains(Browser.this.downloadExtensions[i])) continue;
                                    change = false;
                                    break;
                                }
                                if (change) {
                                    Browser.this.lastUrl = Browser.this.txtURL.getText();
                                    Browser.this.txtURL.setText(newValue);
                                }
                                Browser.this.checkDownload(newValue);
                            }
                        });
                    }
                });
                Browser.this.engine.getLoadWorker().workDoneProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, final Number newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Browser.this.progressBar.setValue(newValue.intValue());
                            }
                        });
                    }
                });
                Browser.this.engine.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

                    public void changed(ObservableValue<? extends Throwable> o, Throwable old, final Throwable value) {
                        if (Browser.this.engine.getLoadWorker().getState() == Worker.State.FAILED) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(Browser.this.panel, value != null ? Browser.this.engine.getLocation() + "\n" + value.getMessage() : Browser.this.engine.getLocation() + "\nUnexpected error.", "Loading error...", 0);
                                }
                            });
                        }
                    }
                });
                Browser.this.jfxPanel.setScene(new Scene((Parent)view));
            }
        });
    }

    public void setURL(final String url) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String tmp = Browser.toURL(url);
                if (tmp == null) {
                    tmp = Browser.toURL("http://" + url);
                }
                Browser.this.engine.load(tmp);
            }
        });
    }

    private static String toURL(String str) {
        try {
            return new URL(str).toExternalForm();
        }
        catch (MalformedURLException exception) {
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            new SyntheticaLicense().register();
            UIManager.setLookAndFeel("de.javasoft.plaf.synthetica.SyntheticaBlackEyeLookAndFeel");
        }
        catch (Exception e) {
            try {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    System.out.println(info.getName());
                    if (!info.getName().toLowerCase().contains("nimb")) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Browser browser = new Browser();
                browser.setVisible(true);
                browser.setURL("http://cpc-live.com/");
                JFrame fram = new JFrame("JavaCPC Webbrowser - \u00a9 2020 by Markus Hohmann");
                fram.setDefaultCloseOperation(3);
                Component c = browser.getComponent(0);
                c.setPreferredSize(new Dimension(800, 600));
                fram.add(c);
                fram.pack();
                fram.setVisible(true);
            }
        });
    }
}

